Create or Replace PACKAGE pkg_ALKINDI_CLUSTER
AS
  TYPE cluster_cursor_type is ref cursor;

  PROCEDURE preCluster(
    o_error_code out number
  );

  PROCEDURE getCoreProdEvals (
    i_product_cluster_id in  PRODUCT_CLUSTER.product_cluster_id%type,
    o_cluster_cursor     out cluster_cursor_type,
    o_error_code         out number
  );

  PROCEDURE getRecProdEvals (
    i_product_cluster_id in  PRODUCT_CLUSTER.product_cluster_id%type,
    o_cluster_cursor     out cluster_cursor_type,
    o_error_code         out number
  );

  PROCEDURE getRecProdUCStats (
    i_product_cluster_id in  PRODUCT_CLUSTER.product_cluster_id%type,
    o_cluster_cursor     out cluster_cursor_type,
    o_error_code         out number
  );

  PROCEDURE getCoreProdUCStats (
    i_product_cluster_id in  PRODUCT_CLUSTER.product_cluster_id%type,
    o_cluster_cursor     out cluster_cursor_type,
    o_error_code         out number
  );

  PROCEDURE getRecProds (
    i_product_cluster_id in  PRODUCT_CLUSTER.product_cluster_id%type,
    o_cluster_cursor     out cluster_cursor_type,
    o_error_code         out number
  );

  PROCEDURE getCoreProds (
    i_product_cluster_id in  PRODUCT_CLUSTER.product_cluster_id%type,
    o_cluster_cursor     out cluster_cursor_type,
    o_error_code         out number
  );

  PROCEDURE updateAvgProdRatingByUC (
  	i_product_id 		in PROD_UC_STAT.PRODUCT_ID%TYPE,
	i_ucid				in PROD_UC_STAT.USER_CLUSTER_ID%TYPE,
	i_avg_rating		in PROD_UC_STAT.AVG_PROD_RATING_BY_UC%TYPE,
	o_ERROR_CODE		out NUMBER
  );

  PROCEDURE sp_SEL_UCID_From_UCIndex (
	i_PRODUCT_CLUSTER_ID IN  USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_USER_CLUSTER_INDEX IN  USER_CLUSTER.USER_CLUSTER_INDEX%TYPE,
	o_USER_CLUSTER_ID    OUT USER_CLUSTER.USER_CLUSTER_ID%TYPE,
	o_ERROR_CODE         OUT NUMBER
  );

  PROCEDURE sp_CNT_UC_By_PC(
	i_PRODUCT_CLUSTER_ID IN  USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_COUNT_OF_UC        OUT NUMBER,
	o_ERROR_CODE         OUT NUMBER
  );

  PROCEDURE sp_CNT_User_By_UC(
	i_USER_CLUSTER_ID IN  REL_USER_CLUSTER.USER_CLUSTER_ID%TYPE,
	o_COUNT_OF_User   OUT NUMBER,
	o_ERROR_CODE      OUT NUMBER
  );

  PROCEDURE sp_INS_USER_Into_UC(
	i_USER_ID            IN  REL_USER_CLUSTER.USER_ID%TYPE,
	i_USER_CLUSTER_INDEX IN  USER_CLUSTER.USER_CLUSTER_INDEX%TYPE,
	i_PRODUCT_CLUSTER_ID IN  USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_ERROR_CODE         OUT NUMBER
  );

  PROCEDURE sp_INS_USER_Into_UC_with_UCID(
	i_USER_ID            IN  REL_USER_CLUSTER.USER_ID%TYPE,
	i_USER_CLUSTER_ID    IN  USER_CLUSTER.USER_CLUSTER_ID%TYPE,
	i_PRODUCT_CLUSTER_ID IN  USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_ERROR_CODE         OUT NUMBER
  );

  PROCEDURE sp_CNT_User_By_UC_INDEX(
	i_USER_CLUSTER_INDEX IN  USER_CLUSTER.USER_CLUSTER_INDEX%TYPE,
	i_PRODUCT_CLUSTER_ID IN  USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_COUNT_OF_User      OUT NUMBER,
	o_ERROR_CODE         OUT NUMBER
  );

  PROCEDURE sp_INS_UC_By_PC_UC_INDEX(
	i_PRODUCT_CLUSTER_ID IN USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_USER_CLUSTER_INDEX IN USER_CLUSTER.USER_CLUSTER_INDEX%TYPE
  );

  PROCEDURE sp_INS_Cluster_User(
	i_USER_ID IN EVALUATION.USER_ID%TYPE
  );

  PROCEDURE sp_DEL_UC_By_PC(
	i_PRODUCT_CLUSTER_ID IN USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE
  );

END pkg_ALKINDI_CLUSTER;
/

Create or Replace PACKAGE BODY pkg_ALKINDI_CLUSTER
AS

-- ==========================================================================================

PROCEDURE preCluster(
  o_error_code out number
) is
BEGIN
  -- Refresh materialized view of "CORE PRODUCTS"
  dbms_mview.refresh('CORE_PROD_CLUSTER');
END preCluster;

-- ==========================================================================================

PROCEDURE getCoreProdEvals (
  i_product_cluster_id in  PRODUCT_CLUSTER.product_cluster_id%type,
  o_cluster_cursor     out cluster_cursor_type,
  o_error_code         out number
) is
BEGIN

  o_error_code := 0;

  open o_cluster_cursor for
  select
  	R.user_id,
    R.product_id,
    R.evaluation_scale_id
  from
    RATING R,
    CORE_PROD_CLUSTER CPC
  where
    CPC.product_cluster_id = i_product_cluster_id and
    R.product_id = CPC.product_id;

EXCEPTION

  when others then
    o_error_code := -1;
	close o_cluster_cursor;

END getCoreProdEvals;

-- ==========================================================================================

PROCEDURE getRecProdEvals (
  i_product_cluster_id in  PRODUCT_CLUSTER.product_cluster_id%type,
  o_cluster_cursor     out cluster_cursor_type,
  o_error_code         out number
) is
BEGIN

  o_error_code := 0;

  open o_cluster_cursor for
  select
  	R.user_id,
    R.product_id,
    R.evaluation_scale_id
  from
    RATING R,
    RECOMMENDABLE_PROD_CLUSTER RPC
  where
    RPC.product_cluster_id = i_product_cluster_id and
    R.product_id = RPC.product_id;

EXCEPTION

  when others then
    o_error_code := -1;
	close o_cluster_cursor;

END getRecProdEvals;

-- ==========================================================================================

PROCEDURE getRecProdUCStats (
  i_product_cluster_id in  PRODUCT_CLUSTER.product_cluster_id%type,
  o_cluster_cursor     out cluster_cursor_type,
  o_error_code         out number
) is
BEGIN

  o_error_code := 0;

  open o_cluster_cursor for
  select
    S.user_cluster_id,
	S.user_cluster_index,
    S.product_id,
    S.avg_prod_rating_by_uc
  from
    PROD_UC_STAT S,
    RECOMMENDABLE_PROD_CLUSTER RPC
  where
    RPC.product_cluster_id = i_product_cluster_id and
    S.product_id = RPC.product_id and
	S.product_cluster_id = RPC.product_cluster_id;

EXCEPTION

  when others then
    o_error_code := -1;
	close o_cluster_cursor;

END getRecProdUCStats;

-- ==========================================================================================

PROCEDURE getCoreProdUCStats (
  i_product_cluster_id in  PRODUCT_CLUSTER.product_cluster_id%type,
  o_cluster_cursor     out cluster_cursor_type,
  o_error_code         out number
) is
BEGIN

  o_error_code := 0;

  open o_cluster_cursor for
  select
    S.user_cluster_id,
	S.user_cluster_index,
    S.product_id,
    S.avg_prod_rating_by_uc
  from
    PROD_UC_STAT S,
    CORE_PROD_CLUSTER CPC
  where
    CPC.product_cluster_id = i_product_cluster_id and
    S.product_id = CPC.product_id and
	S.product_cluster_id = CPC.product_cluster_id;

EXCEPTION

  when others then
    o_error_code := -1;
	close o_cluster_cursor;

END getCoreProdUCStats;

-- ==========================================================================================

PROCEDURE getRecProds (
  i_product_cluster_id in  PRODUCT_CLUSTER.product_cluster_id%type,
  o_cluster_cursor     out cluster_cursor_type,
  o_error_code         out number
) is
BEGIN

  o_error_code := 0;

  open o_cluster_cursor for
  select
    RPC.product_id
  from
    RECOMMENDABLE_PROD_CLUSTER RPC
  where
    RPC.product_cluster_id = i_product_cluster_id;

EXCEPTION

  when others then
    o_error_code := -1;
	close o_cluster_cursor;

END getRecProds;

-- ==========================================================================================

PROCEDURE getCoreProds (
  i_product_cluster_id in  PRODUCT_CLUSTER.product_cluster_id%type,
  o_cluster_cursor     out cluster_cursor_type,
  o_error_code         out number
) is
BEGIN

  o_error_code := 0;

  open o_cluster_cursor for
  select
    CPC.product_id
  from
    CORE_PROD_CLUSTER CPC
  where
    CPC.product_cluster_id = i_product_cluster_id;

EXCEPTION

  when others then
    o_error_code := -1;
	close o_cluster_cursor;

END getCoreProds;

-- ==========================================================================================

PROCEDURE updateAvgProdRatingByUC (
  i_product_id in PROD_UC_STAT.product_id%type,
  i_ucid       in PROD_UC_STAT.user_cluster_id%type,
  i_avg_rating in PROD_UC_STAT.avg_prod_rating_by_uc%type,
  o_error_code out number
) is
BEGIN

  o_error_code := 0;

  UPDATE
    PROD_UC_STAT pus
  SET
    pus.AVG_PROD_RATING_BY_UC = i_avg_rating
  WHERE
    pus.PRODUCT_ID = i_product_id and
    pus.USER_CLUSTER_ID = i_ucid;

EXCEPTION

  when others then
    o_error_code := -1;

END  updateAvgProdRatingByUC;

-- ==========================================================================================

  PROCEDURE sp_SEL_UCID_From_UCIndex(

-- selecting user_id from the user_cluster_index

	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_USER_CLUSTER_INDEX	IN		USER_CLUSTER.USER_CLUSTER_INDEX%TYPE,
	o_USER_CLUSTER_ID		OUT		USER_CLUSTER.USER_CLUSTER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;

	SELECT USER_CLUSTER_ID INTO o_USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
	   AND USER_CLUSTER_INDEX = i_USER_CLUSTER_INDEX;

   EXCEPTION
	WHEN NO_DATA_FOUND THEN
		o_ERROR_CODE	:= 6572;						  -- no data is found for that user_cluster_index
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6573;						  -- general errors when selecting user_cluster_id
												  -- from user_cluster_index

   END sp_SEL_UCID_From_UCIndex;

-- ==========================================================================================

  PROCEDURE sp_CNT_UC_By_PC(

-- For a supplied product cluster, count user_cluster_id

	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_COUNT_OF_UC		OUT		NUMBER,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	SELECT COUNT(USER_CLUSTER_ID) INTO o_COUNT_OF_UC
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID;

   EXCEPTION
	WHEN NO_DATA_FOUND THEN
		o_ERROR_CODE	:= -1;
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;

   END sp_CNT_UC_By_PC;

-- ==========================================================================================

  PROCEDURE sp_CNT_User_By_UC(							-- For a supplied user cluster, count the number of users

	i_USER_CLUSTER_ID		IN		REL_USER_CLUSTER.USER_CLUSTER_ID%TYPE,
	o_COUNT_OF_User		OUT		NUMBER,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	SELECT COUNT(USER_ID) INTO o_COUNT_OF_User
	  FROM REL_USER_CLUSTER
	 WHERE USER_CLUSTER_ID = i_USER_CLUSTER_ID;

   EXCEPTION
	WHEN NO_DATA_FOUND THEN
		o_ERROR_CODE	:= -1;
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;

   END sp_CNT_User_By_UC;

-- ==========================================================================================

  PROCEDURE sp_INS_USER_Into_UC(							-- Insert a user_id into the user cluster

	i_USER_ID			IN		REL_USER_CLUSTER.USER_ID%TYPE,
	i_USER_CLUSTER_INDEX	IN		USER_CLUSTER.USER_CLUSTER_INDEX%TYPE,
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)
   IS
   	v_USER_CLUSTER_ID NUMBER;
   BEGIN
	o_ERROR_CODE	:= 0;

	SELECT USER_CLUSTER_ID into v_USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE USER_CLUSTER_INDEX = i_USER_CLUSTER_INDEX
	   AND PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID;

	INSERT INTO REL_USER_CLUSTER (USER_CLUSTER_ID, USER_CLUSTER_SUBGROUP_INDEX, PRODUCT_CLUSTER_ID, USER_ID) VALUES (v_USER_CLUSTER_ID, 0, i_PRODUCT_CLUSTER_ID, i_USER_ID);

   EXCEPTION
	WHEN DUP_VAL_ON_INDEX THEN

	UPDATE REL_USER_CLUSTER
	   SET USER_CLUSTER_ID = v_USER_CLUSTER_ID
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
	   AND USER_ID = i_USER_ID;

--	WHEN OTHERS THEN
--		o_ERROR_CODE	:= -1;

   END sp_INS_USER_Into_UC;

-- ==========================================================================================

  PROCEDURE sp_INS_USER_Into_UC_with_UCID(							-- Insert a user_id into the user cluster
	i_USER_ID				IN		REL_USER_CLUSTER.USER_ID%TYPE,
	i_USER_CLUSTER_ID		IN		USER_CLUSTER.USER_CLUSTER_ID%TYPE,
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_ERROR_CODE			OUT		NUMBER)
   IS
   mySQLErrM VARCHAR2(4000); -- debugging
   	v_USER_CLUSTER_ID NUMBER;
   BEGIN
	o_ERROR_CODE	:= 0;

	INSERT INTO REL_USER_CLUSTER (
	   USER_CLUSTER_ID,
	   USER_CLUSTER_SUBGROUP_INDEX,
	   PRODUCT_CLUSTER_ID,
	   USER_ID
	) VALUES (
	   i_USER_CLUSTER_ID,
	   0,
	   i_PRODUCT_CLUSTER_ID,
	   i_USER_ID
	);

   END sp_INS_USER_Into_UC_with_UCID;

-- ==========================================================================================

  PROCEDURE sp_CNT_User_By_UC_INDEX(						-- For a supplied user cluster index, count the number of users

	i_USER_CLUSTER_INDEX	IN		USER_CLUSTER.USER_CLUSTER_INDEX%TYPE,
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_COUNT_OF_User		OUT		NUMBER,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	SELECT COUNT(USER_ID) INTO o_COUNT_OF_User
	  FROM REL_USER_CLUSTER
	 WHERE USER_CLUSTER_ID =
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE USER_CLUSTER_INDEX = i_USER_CLUSTER_INDEX
	   AND PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID);

--   EXCEPTION
--	WHEN OTHERS THEN
--		o_ERROR_CODE	:= -1;

   END sp_CNT_User_By_UC_INDEX;

-- ==========================================================================================

  PROCEDURE sp_INS_UC_By_PC_UC_INDEX(
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_USER_CLUSTER_INDEX	IN		USER_CLUSTER.USER_CLUSTER_INDEX%TYPE)

   IS BEGIN
	INSERT
	  INTO USER_CLUSTER (USER_CLUSTER_ID, USER_CLUSTER_INDEX, PRODUCT_CLUSTER_ID)
	VALUES (sq_USER_CLUSTER_ID.NEXTVAL, i_USER_CLUSTER_INDEX, i_PRODUCT_CLUSTER_ID);

   END sp_INS_UC_By_PC_UC_INDEX;

-- ==========================================================================================

  PROCEDURE sp_INS_Cluster_User(
	i_USER_ID			IN		EVALUATION.USER_ID%TYPE)
  IS
	CURSOR c_PC_UC_DIFF IS
      select
        S.product_cluster_id,
        S.user_cluster_id,
        sum(power((S.avg_prod_rating_by_uc - E.evaluation_scale_id),2)) diff
      from
        PROD_UC_STAT S,
        RATING E
      WHERE
        E.user_id = i_user_id and
        S.product_id = E.product_id and
        exists (
          select 'x'
          from
            CORE_PROD_CLUSTER CPC
          where
            CPC.product_cluster_id = S.product_cluster_id AND
            CPC.product_id = E.product_id
        )
      group by
        s.product_cluster_id,
        s.user_cluster_id
      order by
        s.product_cluster_id,
        s.user_cluster_id;

-- [RC] 2001/05/02: was
--		SELECT S.PRODUCT_CLUSTER_ID
--	     	     , S.USER_CLUSTER_ID
--		     , SUM(POWER((S.AVG_PROD_RATING_BY_UC - E.EVALUATION_SCALE_ID),2)) as DIFF
--		  FROM PROD_UC_STAT S, EVALUATION E
--		 WHERE -- S.PRODUCT_ID IN (SELECT PRODUCT_ID FROM EVALUATION WHERE USER_ID = i_USER_ID) AND
--		       S.PRODUCT_ID = E.PRODUCT_ID
--		   AND E.USER_ID = i_USER_ID
--		   AND E.EVALUATION_SCALE_ID >=1
--	    GROUP BY S.PRODUCT_CLUSTER_ID, S.USER_CLUSTER_ID
--	    ORDER BY S.PRODUCT_CLUSTER_ID, S.USER_CLUSTER_ID;

	v_PC_UC_DIFF c_PC_UC_DIFF%ROWTYPE;
	v_PC_ID NUMBER;
	v_UC_ID NUMBER;
	v_DIFF NUMBER(8,3);

	v_ERROR_CODE	   NUMBER;
  BEGIN
    -- take this User out of all User Clusters
    DELETE FROM REL_USER_CLUSTER WHERE USER_ID = i_USER_ID;

	OPEN c_PC_UC_DIFF;

	FETCH c_PC_UC_DIFF INTO v_PC_UC_DIFF;
	v_PC_ID	:= v_PC_UC_DIFF.PRODUCT_CLUSTER_ID;
	v_UC_ID	:= v_PC_UC_DIFF.USER_CLUSTER_ID;
	v_DIFF	:= v_PC_UC_DIFF.DIFF;

	WHILE c_PC_UC_DIFF%FOUND
	LOOP
	  BEGIN
		IF v_PC_UC_DIFF.PRODUCT_CLUSTER_ID = v_PC_ID THEN
			IF v_PC_UC_DIFF.DIFF < v_DIFF THEN
				v_DIFF := v_PC_UC_DIFF.DIFF;
				v_UC_ID := v_PC_UC_DIFF.USER_CLUSTER_ID;
			END IF;
		ELSE
			INSERT INTO REL_USER_CLUSTER (USER_CLUSTER_ID, USER_CLUSTER_SUBGROUP_INDEX, PRODUCT_CLUSTER_ID, USER_ID)
			VALUES (v_UC_ID, 0, v_PC_ID, i_USER_ID);
			v_PC_ID := v_PC_UC_DIFF.PRODUCT_CLUSTER_ID;
			v_DIFF := v_PC_UC_DIFF.DIFF;
			v_UC_ID := v_PC_UC_DIFF.USER_CLUSTER_ID;
		END IF;

		FETCH c_PC_UC_DIFF into v_PC_UC_DIFF;
	  END;

	END LOOP;

    if c_PC_UC_DIFF%ROWCOUNT > 0 then
		IF v_PC_UC_DIFF.PRODUCT_CLUSTER_ID = v_PC_ID THEN
			IF v_PC_UC_DIFF.DIFF < v_DIFF THEN
				v_DIFF := v_PC_UC_DIFF.DIFF;
				v_UC_ID := v_PC_UC_DIFF.USER_CLUSTER_ID;
			END IF;
		END IF;
		INSERT INTO REL_USER_CLUSTER (USER_CLUSTER_ID, USER_CLUSTER_SUBGROUP_INDEX, PRODUCT_CLUSTER_ID, USER_ID)
		VALUES (v_UC_ID, 0, v_PC_ID, i_USER_ID);
    end if;

	CLOSE c_PC_UC_DIFF;

   	pkg_ALKINDI_STAT.sp_INS_ReCalc_USER_DATA_STAT_1(i_USER_ID, v_ERROR_CODE);
    if v_ERROR_CODE != 0 then
   	   raise_application_error(-20001, 'Error '||to_char(v_ERROR_CODE)||' from procedure sp_INS_ReCalc_USER_DATA_STAT_1('||to_char(i_USER_ID)||','||to_char(v_ERROR_CODE)||')');
   	end if;

 END sp_INS_Cluster_User;

-- ==========================================================================================

  PROCEDURE sp_DEL_UC_By_PC(
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE)
   IS BEGIN

	DELETE
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID;

  END sp_DEL_UC_By_PC;

-- ==========================================================================================

END pkg_ALKINDI_CLUSTER;
/
